/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.api.requirement;

import com.agricraft.agricraft.api.AgriApi;
import com.agricraft.agricraft.api.AgriRegistrable;
import com.agricraft.agricraft.api.AgriRegistry;
import com.agricraft.agricraft.api.codecs.AgriBlockCondition;
import com.agricraft.agricraft.api.codecs.AgriFluidCondition;
import com.agricraft.agricraft.api.codecs.AgriListCondition;
import com.agricraft.agricraft.api.codecs.AgriRequirement;
import com.agricraft.agricraft.api.codecs.AgriSoil;
import com.agricraft.agricraft.api.codecs.AgriSoilCondition;
import com.agricraft.agricraft.api.codecs.AgriSoilValue;
import com.agricraft.agricraft.api.crop.AgriCrop;
import com.agricraft.agricraft.api.plant.AgriPlant;
import com.agricraft.agricraft.api.requirement.AgriGrowthCondition;
import com.agricraft.agricraft.api.requirement.AgriGrowthResponse;
import com.agricraft.agricraft.api.requirement.AgriSeason;
import com.agricraft.agricraft.common.util.Platform;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2688;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_4538;
import net.minecraft.class_5321;
import net.minecraft.class_6880;

public class AgriGrowthConditionRegistry
extends AgriRegistry<BaseGrowthCondition<?>> {
    private static AgriGrowthConditionRegistry INSTANCE;
    private final BaseGrowthCondition<AgriSoilCondition.Humidity> humidity = new BaseGrowthCondition<AgriSoilCondition.Humidity>("humidity", (plant, strength, value) -> AgriGrowthConditionRegistry.handleSoilCriterion(strength, value, plant.getGrowthRequirements().soilHumidity()), (level, blockPos) -> AgriApi.getCrop((class_1922)level, blockPos).flatMap(AgriCrop::getSoil).map(AgriSoil::humidity).orElse(AgriSoilCondition.Humidity.INVALID));
    private final BaseGrowthCondition<AgriSoilCondition.Acidity> acidity = new BaseGrowthCondition<AgriSoilCondition.Acidity>("acidity", (plant, strength, value) -> AgriGrowthConditionRegistry.handleSoilCriterion(strength, value, plant.getGrowthRequirements().soilAcidity()), (level, blockPos) -> AgriApi.getCrop((class_1922)level, blockPos).flatMap(AgriCrop::getSoil).map(AgriSoil::acidity).orElse(AgriSoilCondition.Acidity.INVALID));
    private final BaseGrowthCondition<AgriSoilCondition.Nutrients> nutrients = new BaseGrowthCondition<AgriSoilCondition.Nutrients>("nutrients", (plant, strength, value) -> AgriGrowthConditionRegistry.handleSoilCriterion(strength, value, plant.getGrowthRequirements().soilNutrients()), (level, blockPos) -> AgriApi.getCrop((class_1922)level, blockPos).flatMap(AgriCrop::getSoil).map(AgriSoil::nutrients).orElse(AgriSoilCondition.Nutrients.INVALID));
    private final BaseGrowthCondition<Integer> light = new BaseGrowthCondition<Integer>("light", (plant, strength, value) -> {
        AgriRequirement requirement = plant.getGrowthRequirements();
        int lower = requirement.minLight() - (int)(requirement.lightToleranceFactor() * (double)strength);
        int upper = requirement.maxLight() + (int)(requirement.lightToleranceFactor() * (double)strength);
        return lower <= value && value <= upper ? AgriGrowthResponse.FERTILE : AgriGrowthResponse.INFERTILE;
    }, class_4538::method_22339);
    private final BaseGrowthCondition<class_2680> block = new BaseGrowthCondition<class_2680>("block", (plant, strength, blockstate) -> {
        List<AgriBlockCondition> blockConditions = plant.getGrowthRequirements().blockConditions();
        if (blockConditions.isEmpty()) {
            return AgriGrowthResponse.FERTILE;
        }
        for (AgriBlockCondition blockCondition : blockConditions) {
            if (strength >= blockCondition.strength()) continue;
            List<class_2248> requiredBlocks = Platform.get().getBlocksFromLocation(blockCondition.block());
            if (requiredBlocks.contains(blockstate.method_26204())) {
                if (blockCondition.states().isEmpty()) {
                    return AgriGrowthResponse.FERTILE;
                }
                Set list = blockstate.method_11656().entrySet().stream().map(class_2688.field_24737).collect(Collectors.toSet());
                if (list.containsAll(blockCondition.states())) {
                    return AgriGrowthResponse.FERTILE;
                }
            }
            return AgriGrowthResponse.INFERTILE;
        }
        return AgriGrowthResponse.FERTILE;
    }, (level, blockPos) -> level.method_8320(blockPos.method_10074().method_10074()));
    private final BaseGrowthCondition<class_6880<class_1959>> biome = new BaseGrowthCondition<class_6880>("biome", (plant, strength, biome) -> {
        AgriListCondition listCondition = plant.getGrowthRequirements().biomes();
        if (strength >= listCondition.ignoreFromStrength() || listCondition.blacklist() && listCondition.isEmpty()) {
            return AgriGrowthResponse.FERTILE;
        }
        if (listCondition.blacklist()) {
            if (listCondition.values().stream().anyMatch(arg_0 -> ((class_6880)biome).method_40226(arg_0))) {
                return AgriGrowthResponse.INFERTILE;
            }
        } else if (listCondition.values().stream().noneMatch(arg_0 -> ((class_6880)biome).method_40226(arg_0))) {
            return AgriGrowthResponse.INFERTILE;
        }
        return AgriGrowthResponse.FERTILE;
    }, class_4538::method_23753);
    private final BaseGrowthCondition<class_5321<class_2874>> dimension = new BaseGrowthCondition<class_5321>("dimension", (plant, strength, dimension) -> {
        AgriListCondition listCondition = plant.getGrowthRequirements().dimensions();
        if (strength >= listCondition.ignoreFromStrength() || listCondition.blacklist() && listCondition.isEmpty()) {
            return AgriGrowthResponse.FERTILE;
        }
        if (listCondition.blacklist()) {
            if (listCondition.values().stream().anyMatch(arg_0 -> ((class_2960)dimension.method_29177()).equals(arg_0))) {
                return AgriGrowthResponse.INFERTILE;
            }
        } else if (listCondition.values().stream().noneMatch(arg_0 -> ((class_2960)dimension.method_29177()).equals(arg_0))) {
            return AgriGrowthResponse.INFERTILE;
        }
        return AgriGrowthResponse.FERTILE;
    }, (level, blockPos) -> level.method_44013());
    private final BaseGrowthCondition<AgriSeason> season = new BaseGrowthCondition<AgriSeason>("season", (plant, strength, season) -> {
        block3: {
            block2: {
                List<AgriSeason> seasons = plant.getGrowthRequirements().seasons();
                if (!AgriApi.getSeasonLogic().isActive() || seasons.isEmpty() || strength >= AgriApi.getStatRegistry().strengthStat().getMax()) break block2;
                if (!seasons.stream().anyMatch(season::matches)) break block3;
            }
            return AgriGrowthResponse.FERTILE;
        }
        return AgriGrowthResponse.INFERTILE;
    }, (level, blockPos) -> AgriApi.getSeasonLogic().getSeason((class_1937)level, (class_2338)blockPos));
    private final BaseGrowthCondition<class_3610> fluid = new BaseGrowthCondition<class_3610>("fluid", (plant, strength, fluid) -> {
        AgriFluidCondition fluidCondition = plant.getGrowthRequirements().fluidCondition();
        List<class_3611> requiredFluids = Platform.get().getFluidsFromLocation(fluidCondition.fluid());
        if (requiredFluids.isEmpty()) {
            if (fluid.method_39360((class_3611)class_3612.field_15908)) {
                return AgriGrowthResponse.KILL_IT_WITH_FIRE;
            }
            return fluid.method_39360(class_3612.field_15906) ? AgriGrowthResponse.FERTILE : AgriGrowthResponse.LETHAL;
        }
        if (requiredFluids.contains(fluid.method_15772())) {
            if (fluidCondition.states().isEmpty()) {
                return AgriGrowthResponse.FERTILE;
            }
            Set list = fluid.method_11656().entrySet().stream().map(class_2688.field_24737).collect(Collectors.toSet());
            return list.containsAll(fluidCondition.states()) ? AgriGrowthResponse.FERTILE : AgriGrowthResponse.LETHAL;
        }
        return fluid.method_39360((class_3611)class_3612.field_15908) ? AgriGrowthResponse.FERTILE : AgriGrowthResponse.LETHAL;
    }, class_1937::method_8316);

    private AgriGrowthConditionRegistry() {
    }

    public static AgriGrowthConditionRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AgriGrowthConditionRegistry();
            INSTANCE.add(AgriGrowthConditionRegistry.INSTANCE.humidity);
            INSTANCE.add(AgriGrowthConditionRegistry.INSTANCE.acidity);
            INSTANCE.add(AgriGrowthConditionRegistry.INSTANCE.nutrients);
            INSTANCE.add(AgriGrowthConditionRegistry.INSTANCE.light);
            INSTANCE.add(AgriGrowthConditionRegistry.INSTANCE.block);
            INSTANCE.add(AgriGrowthConditionRegistry.INSTANCE.biome);
            INSTANCE.add(AgriGrowthConditionRegistry.INSTANCE.dimension);
            INSTANCE.add(AgriGrowthConditionRegistry.INSTANCE.season);
            INSTANCE.add(AgriGrowthConditionRegistry.INSTANCE.fluid);
        }
        return INSTANCE;
    }

    public static BaseGrowthCondition<AgriSoilCondition.Humidity> getHumidity() {
        return AgriGrowthConditionRegistry.getInstance().humidity;
    }

    public static BaseGrowthCondition<AgriSoilCondition.Acidity> getAcidity() {
        return AgriGrowthConditionRegistry.getInstance().acidity;
    }

    public static BaseGrowthCondition<AgriSoilCondition.Nutrients> getNutrients() {
        return AgriGrowthConditionRegistry.getInstance().nutrients;
    }

    public static BaseGrowthCondition<Integer> getLight() {
        return AgriGrowthConditionRegistry.getInstance().light;
    }

    public static BaseGrowthCondition<class_2680> getBlock() {
        return AgriGrowthConditionRegistry.getInstance().block;
    }

    public static BaseGrowthCondition<class_6880<class_1959>> getBiome() {
        return AgriGrowthConditionRegistry.getInstance().biome;
    }

    public static BaseGrowthCondition<class_5321<class_2874>> getDimension() {
        return AgriGrowthConditionRegistry.getInstance().dimension;
    }

    public static BaseGrowthCondition<AgriSeason> getSeason() {
        return AgriGrowthConditionRegistry.getInstance().season;
    }

    public static BaseGrowthCondition<class_3610> getFluid() {
        return AgriGrowthConditionRegistry.getInstance().fluid;
    }

    private static AgriGrowthResponse handleSoilCriterion(int strength, AgriSoilValue value, AgriSoilCondition<?> condition) {
        int lower = condition.type().lowerLimit(condition.value().ordinal() - (int)(condition.toleranceFactor() * (double)strength));
        int upper = condition.type().upperLimit(condition.value().ordinal() + (int)(condition.toleranceFactor() * (double)strength));
        if (value.isValid() && lower <= value.ordinal() && value.ordinal() <= upper) {
            return AgriGrowthResponse.FERTILE;
        }
        return AgriGrowthResponse.INFERTILE;
    }

    public static class BaseGrowthCondition<T>
    implements AgriGrowthCondition<T>,
    AgriRegistrable {
        private final String id;
        private final ResponseGetter<T> response;
        private final BiFunction<class_1937, class_2338, T> getter;

        public BaseGrowthCondition(String id, ResponseGetter<T> response, BiFunction<class_1937, class_2338, T> getter) {
            this.id = id;
            this.response = response;
            this.getter = getter;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public AgriGrowthResponse check(AgriCrop crop, class_1937 level, class_2338 pos, int strength) {
            return this.response.apply(crop.getPlant(), strength, this.getter.apply(level, pos));
        }

        @Override
        public AgriGrowthResponse apply(AgriPlant plant, int strength, T value) {
            return this.response.apply(plant, strength, value);
        }

        @Override
        public void notMetDescription(Consumer<class_2561> consumer) {
            consumer.accept((class_2561)class_2561.method_43471((String)("agricraft.tooltip.condition." + this.id)));
        }
    }

    public static interface ResponseGetter<T> {
        public AgriGrowthResponse apply(AgriPlant var1, int var2, T var3);
    }
}

